#!/usr/bin/env python

import vtk
import time

print '----------------------------------------------------'

## Definition de la fenetre d'affichage
fenetre1 = vtk.vtkRenderWindow()
fenetre1.SetSize(500,500)
fenetre1.SetPosition(50,50) 
fenetre1.SetWindowName("Fenetre 1")

## Recuperation des donnees : ici une sphere
sphere1 = vtk.vtkSphereSource()
sphere1.SetRadius(1.0)             # Set radius of sphere. Default is .5.
sphere1.SetCenter(0.0,1.0,0.0)     # Set the center of the sphere. Default is 0,0,0.
sphere1.SetThetaResolution(20)      # Set the number of points in the longitude direction 
sphere1.SetPhiResolution(30)        # Set the number of points in the latitude direction

## Conversion des donnees en primitives graphiques 
mappersphere1 = vtk.vtkPolyDataMapper()
mappersphere1.SetInput(sphere1.GetOutput())

## Definition des acteurs de la scene
acteursphere1 = vtk.vtkActor()
acteursphere1.SetMapper(mappersphere1)

## Definition de la scene : 
ren1 = vtk.vtkRenderer()
ren1.AddActor(acteursphere1)
ren1.SetBackground(0,1,0)      # On change le fond de la fenetre
fenetre1.AddRenderer(ren1)

## On joue sur la couleur de l'acteur
print acteursphere1
print acteursphere1.GetProperty()
acteursphere1.GetProperty().SetColor(1,0,0)    # On change la couleur de la sphere
print acteursphere1.GetProperty().GetAmbient() # On affiche l'intensite de la lumiere d'ambiance
for i in range(1,11):
    amb=i*1.0/10
    print amb
    acteursphere1.GetProperty().SetAmbient(amb) # On modifie l'intensite de la lumiere d'ambiance .
    fenetre1.Render()
    time.sleep(1)
time.sleep(5)

## Retour a l'etat initial
acteursphere1.GetProperty().SetAmbient(0.0)
acteursphere1.GetProperty().SetColor(1,1,1)
ren1.SetBackground(0,0,0)
fenetre1.Render()
time.sleep(5)

## Maintenant on va ajouter une lumiere a la scene
lum1=vtk.vtkLight()    # On definit une lumiere "infini" (par defaut)
lum1.SetColor(0,0,1)
lum1.SetFocalPoint(ren1.GetActiveCamera().GetFocalPoint())	
lum1.SetPosition(ren1.GetActiveCamera().GetPosition())	
ren1.AddLight(lum1)
fenetre1.Render()
time.sleep(5)

## Retour a l'etat initial
ren1.RemoveLight(lum1)
fenetre1.Render()
time.sleep(5)

## Maintenant on va ajouter une lumiere a la scene
lum2=vtk.vtkLight()    # On definit un spot de lumiere
lum2.PositionalOn()    # pour que cela soit un spot
lum2.SetColor(0,0,1)
lum2.SetFocalPoint(ren1.GetActiveCamera().GetFocalPoint())	
lum2.SetPosition(ren1.GetActiveCamera().GetPosition())
lum2.SetConeAngle(5) # Set the lighting cone angle of a positional light in degrees
ren1.AddLight(lum2)
fenetre1.Render()
time.sleep(5)


print '----------------------------------------------------'
