#!/usr/bin/env python

import vtk

## Definition de la fenetre d'affichage
fenetre = vtk.vtkRenderWindow()
fenetre.SetSize(500,500)
fenetre.SetPosition(50,50) 
fenetre.SetWindowName("Fenetre")

## Recuperation des donnees : ici une sphere
sphere = vtk.vtkSphereSource()
sphere.SetRadius(1.0)            
sphere.SetCenter(0.0,1.0,0.0)   
sphere.SetThetaResolution(600)  
sphere.SetPhiResolution(600)     

colsph = vtk.vtkElevationFilter() 
colsph.SetInput(sphere.GetOutput())
colsph.SetLowPoint(0,1,-1)
colsph.SetHighPoint(0,1,1)


## Conversion des donnees en primitives graphiques 
mappersphere = vtk.vtkPolyDataMapper()
mappersphere.SetInput(colsph.GetOutput())

## Definition des acteurs de la scene
# LOD maxi :
#acteursphere = vtk.vtkActor()
# LOD intermediaire :
acteursphere = vtk.vtkLODActor()
print acteursphere.GetNumberOfCloudPoints()
acteursphere.SetNumberOfCloudPoints(10)

acteursphere.SetMapper(mappersphere)

## Definition de la scene : 
ren = vtk.vtkRenderer()
ren.AddActor(acteursphere)

## Silence, on tourne...
fenetre.AddRenderer(ren)

## Definition de l'interacteur
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(fenetre)   

## Projection :
iren.Initialize() 
fenetre.Render()   
iren.Start()      
