#!/usr/bin/env python

import vtk

## Definition de la fenetre d'affichage
fenetre = vtk.vtkRenderWindow()
fenetre.SetSize(500,500)
fenetre.SetPosition(50,50) 
fenetre.SetWindowName("Fenetre")

## Recuperation des donnees : ici une sphere
sphere = vtk.vtkSphereSource()
sphere.SetThetaResolution(12)   
sphere.SetPhiResolution(12)     

## Coloration de la sphere 
colorIt=vtk.vtkElevationFilter()
colorIt.SetInputConnection(sphere.GetOutputPort())
colorIt.SetLowPoint(0,0,-0.5)
colorIt.SetHighPoint(0,0,0.5)

## Conversion des donnees en primitives graphiques 
mappersphere = vtk.vtkPolyDataMapper()
mappersphere.SetInputConnection(colorIt.GetOutputPort())

## Definition des acteurs de la scene
acteursphere = vtk.vtkActor()
acteursphere.SetMapper(mappersphere)

## Definition de la scene : 
ren = vtk.vtkRenderer()
ren.AddActor(acteursphere)

## Silence, on tourne...
fenetre.AddRenderer(ren)

## Definition de l'interacteur
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(fenetre)   

## Projection :
iren.Initialize()  
fenetre.Render()   
iren.Start()     
