#!/usr/bin/env python

import vtk

## Definition de la fenetre d'affichage
fenetre = vtk.vtkRenderWindow()
fenetre.SetSize(500,500)
fenetre.SetPosition(50,50) 
fenetre.SetWindowName("Fenetre")

## Sphere
sphere = vtk.vtkSphereSource()
sphere.SetThetaResolution(8)     
sphere.SetPhiResolution(8)        

mappersphere = vtk.vtkPolyDataMapper()
mappersphere.SetInputConnection(sphere.GetOutputPort())

acteursphere = vtk.vtkActor()
acteursphere.SetMapper(mappersphere)

## Cone
cone=vtk.vtkConeSource()
cone.SetResolution(6)

## Un cone en chaque point de la sphere
glyph=vtk.vtkGlyph3D()
glyph.SetInputConnection(sphere.GetOutputPort())
glyph.SetSourceConnection(cone.GetOutputPort())
glyph.SetVectorModeToUseNormal()
glyph.SetScaleModeToScaleByVector()
glyph.SetScaleFactor(0.25)

mappercones=vtk.vtkPolyDataMapper()
mappercones.SetInputConnection(glyph.GetOutputPort())

acteurcones=vtk.vtkActor()
acteurcones.SetMapper(mappercones)

## Definition de la scene : 
ren = vtk.vtkRenderer()
ren.AddActor(acteursphere)
ren.AddActor(acteurcones)

## Silence, on tourne...
fenetre.AddRenderer(ren)

## Definition de l'interacteur
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(fenetre)  

## Projection :
iren.Initialize() 
fenetre.Render()   
iren.Start() 
