#!/usr/bin/env python

import vtk
import time

## Definition de la fenetre d'affichage
fenetre = vtk.vtkRenderWindow()
fenetre.SetSize(500,500)
fenetre.SetPosition(50,50) 
fenetre.SetWindowName("Camera")

## Recuperation des donnees : ici un cylindre
cyl = vtk.vtkCylinderSource()
cyl.SetRadius(1.0)             
cyl.SetHeight(4.0)             
cyl.SetCenter(0.0,0.0,0.0)     
cyl.SetResolution(20)      
colorIt=vtk.vtkElevationFilter()
colorIt.SetInputConnection(cyl.GetOutputPort())
colorIt.SetLowPoint(0,0,-0.5)
colorIt.SetHighPoint(0,0,0.5)

## Conversion des donnees en primitives graphiques 
mappercyl = vtk.vtkPolyDataMapper()
mappercyl.SetInput(colorIt.GetOutput())

## Definition des acteurs de la scene
acteurcyl = vtk.vtkActor()
acteurcyl.SetMapper(mappercyl)

## Definition de la scene : 
cam = vtk.vtkCamera()  
cam.SetViewUp(0, 1, 0)      # Set the view up direction for the camera. The default is (0,1,0).
cam.SetPosition(0, 0, -10)  # Set the position of the camera in world coordinates. The default position is (0,0,1).
cam.SetFocalPoint(0, 0, 0)  # Set the focal of the camera in world coordinates. The default focal point is the origin.
print cam

## Definition de la scene : 
ren = vtk.vtkRenderer()
ren.AddActor(acteurcyl)
ren.SetActiveCamera(cam)  
# ren.GetActiveCamera() permet de recuperer la camera active (valeurs par defaut)...
# ren.ResetCamera() met a jour la camera de facon a ce que tous les acteurs soient visibles

## Silence, on tourne...
fenetre.AddRenderer(ren)

## Projection :
for position in range(0,11):
    print 'position=',position
    cam.SetPosition(0, 0, -position)
    fenetre.Render()
    time.sleep(1)
time.sleep(5)
for azimuth in range(0,11):
    print 'azimuth=',azimuth
    cam.Azimuth(azimuth)
    fenetre.Render()
    time.sleep(1)
time.sleep(5)
for roll in range(0,11):
    print 'roll=',roll
    cam.Roll(roll)
    fenetre.Render()
    time.sleep(1)
time.sleep(5)
for yaw in range(0,6):
    print 'yaw=',yaw
    cam.Yaw(yaw)
    fenetre.Render()
    time.sleep(1)
time.sleep(5)



