import numpy as N
import itertools
import getopt
import sys
from Scientific.Geometry import Vector

def analyzeCommandLine():
    opts, args = getopt.getopt(sys.argv[1:], 'vi:')
    visualization = False
    iterations = 1
    for o, a in opts:
        if o == '-v':
            visualization = True
        elif o == '-i':
            iterations = int(a)
    return visualization, iterations

def readData(filename):
    def group(seq, n):
        return itertools.izip(*[itertools.islice(seq, i, None, n)
                                for i in range(n)])
    names = []
    masses = []
    radii = []
    positions = []
    velocities = []
    for data in group(file(filename).readlines(), 5):
        names.append(data[0].strip())
        positions.append(Vector(*[float(x) for x in data[1].split()]))
        velocities.append(Vector(*[float(x) for x in data[2].split()]))
        masses.append(float(data[3].strip()))
        radii.append(float(data[4].strip()))
    return masses, positions, velocities, radii

def setupVisualization(positions):
    import visual
    spheres = [visual.sphere(pos=visual.vector(p[0], p[1], p[2]),
                             radius = 10.,
                             color = visual.color.yellow)
               for p in positions]
    curves = [visual.curve(color = visual.color.green, radius=3.)
              for i in range(len(positions))]
    return zip(spheres, curves)

def updateVisualization(graphics, new_position):
    sphere, curve = graphics
    sphere.pos = new_position
    curve.append(pos = new_position)

