from multiprocessing import cpu_count

default_nprocs = cpu_count()

def distribute(nitems, nprocs=None):
    """
    :param nitems: the number of items to be distributed
    :type nitems: int
    :param nprocs: the number of processors available
    :type nprocs: int
    :returns: a list of index tuples (imin, imax)
              defining the slices of the input sequence
              to be handled by each processor
    :rtyoe: list
    """
    if nprocs is None:
        nprocs = default_nprocs
    nitems_per_proc = (nitems+nprocs-1)/nprocs
    return [(i, min(nitems, i+nitems_per_proc))
            for i in range(0, nitems, nitems_per_proc)]
    
