
import sys
import numpy

class Grid:
  def __init__(self,xsize,ysize):
    self.xsize=xsize
    self.ysize=ysize
    self.imin=0
    self.jmin=0
    self.imax=0
    self.jmax=0
    self.eps=numpy.finfo(numpy.float64).eps
    self._step=0
    self._last=0
    self._data=numpy.ones((xsize,ysize),dtype='d')*numpy.nan
    self._residual=numpy.finfo(numpy.float64).max
  def copy(self):
    g=Grid(self.xsize,self.ysize)
    g.imin=self.imin
    g.jmin=self.jmin
    g.imax=self.imax
    g.jmax=self.jmax
    return g
  def __str__(self):
    return str(self._data)
  def load(self,filename):
    self._data=numpy.load(filename)
  def save(self,filename):
    numpy.save(filename,self._data)
  def initialize(self):
    self._data[:,:]=0.0
    self._data[0,:]=self.imin
    self._data[-1,:]=self.imax
    self._data[:,0]=self.jmin
    self._data[:,-1]=self.jmax
  def laplacien_ufunc(self):
    a=self._data
    prev = a[1:-1, 1:-1]
    new = (a[1:-1,2:]+a[2:,1:-1]+a[1:-1,:-2]+a[:-2,1:-1])/4.0
    self._residual = numpy.repeat(numpy.fabs(prev-new).flat,
                                  (new > 0.0).flat).max()
    a[1:-1, 1:-1] = new
    return self._residual
  def laplacien_boucle(self):
    self._residual=0
    a=self._data
    for i in range(1,self.xsize-1):
      for j in range(1,self.ysize-1):
        u_previous=a[i][j]
        a[i][j]=(a[i][j+1]+a[i+1][j]+a[i][j-1]+a[i-1][j])/4.0
        tmp=abs((u_previous-a[i][j])/a[i][j])
        if ((a[i][j]>0) and (self._residual<tmp)): self._residual=tmp
    return self._residual
  def nextStep(self,step=sys.maxint):
    if (self._step==0): self.initialize()
    self._last=step
    while ((self._step<=self._last) and (self._residual>self.eps)):
      print 'Step # ',self._step
      #self.laplacien_boucle()
      self.laplacien_ufunc()
      self._step+=1
    return self
