      SUBROUTINE initheat( left, top, right, bottom, ni, nj, u )
        IMPLICIT NONE

        !
        REAL(KIND=8), INTENT(IN) :: left, top, right, bottom
        INTEGER, INTENT(IN) :: ni, nj
        !
        REAL(KIND=8), DIMENSION(ni,nj),INTENT(OUT) :: u
        !
        INTEGER :: i,j
        u(:,:) = 0.D0
        DO i = 1, ni
           u(i, 1) = left
           u(i,nj) = right
        END DO
        DO j = 1, nj
           u( 1,j) = top
           u(ni,j) = bottom
        END DO
      END SUBROUTINE initHeat
!
      SUBROUTINE iteration( ni, nj, u, error )
        IMPLICIT NONE
        !
        INTEGER, INTENT(IN) :: ni, nj
        !
        REAL(KIND=8), DIMENSION(ni,nj), INTENT(INOUT) :: u
        REAL(KIND=8), INTENT(OUT) :: error
        !
        INTEGER :: i, j
        REAL(KIND=8) :: u_old
        !
        error = 0.D0
        DO i = 2, ni-1
           DO j = 2, nj-1
              u_old = u(i,j)
              u(i,j) = 0.25*(u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j+1))
              IF (u(i,j).GT.1.D-6) THEN
                error = MAX(error, ABS(u(i,j)-u_old)/ABS(u(i,j)))
             END IF
           END DO
        END DO
      END SUBROUTINE iteration
