      PROGRAM HeatEquation
        IMPLICIT NONE
!
        REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: u
        INTEGER :: ni, nj, iter,i
        REAL(KIND=8) :: left, right, bottom, top, err
!
        ni = 100
        nj = 120
!
        left = 30.
        right= 60.
        bottom = 100.
        top = 0.
!
        ALLOCATE(u(ni,nj))
        CALL initheat( left, top, right, bottom, ni, nj, u)
!
        err = 1.
        iter = 0
        DO WHILE ((err>1.D-6).AND.(iter<65536))
           CALL iteration( ni, ni, u, err)
           iter = iter + 1
           IF (MOD(iter,1).EQ.0) THEN
              WRITE(*,*) 'iter : ', iter, ' -> residual : ', err
           END IF
        END DO
!
      END PROGRAM HeatEquation
