// Programme C/C++
# include <iostream>
# include <cstdlib>
# include <cstdio>

extern"C" void initheat_( const int& left, const int& top,
			  const int& right, const int& bottom,
			  const int& ni, const int& nj,
			  double* u);

extern"C" void iteration_( const int& ni, const int& nj,
			   double* u, double& err);

int main(int nargs, char* argv[])
{
  int ni = 100;
  int nj = 200;
  if (nargs==3) {
    sscanf(argv[1], "%d", &ni);
    sscanf(argv[2], "%d", &nj);
  }
  double* u = new double[ni*nj];
  const double left = 30, right = 60, bottom = 100, top = 0;
  initheat_( left, top, right, bottom, ni, nj, u);


  double err = 1.;
  int    iter = 0;
  while ((err>1.E-6) && (iter < 65536)) {
    iteration_(ni, nj, u, err);
    iter ++;
    if (iter % 10 == 0) std::cout << "iter " << iter
				  << " -> res : " << err << std::endl;
  }
  delete [] u;
  return EXIT_SUCCESS;
}
