#!/usr/bin/env python
# -*- coding: latin-1 -*-
import Geometry
import numpy as N
import time
from threading import Thread

NPOINTS = 2000000
Points = N.empty((NPOINTS,3),N.double)
print "Cration nuage de points"
# Cration d'un nuage de points en dimension 3 :
for i in xrange(NPOINTS) :
    Points[i] = N.random.randn(3)
tr = [1.,-1.,0.]

def testTranslation() :
# Vecteur de translation/rotation t = [1.,-1.,0.]
########################################################################
# Translation normale 
    print "Commence translation sans multi--threads : "
    time_Trans = time.time()
    Translated_Points = Geometry.translate(Points, tr)
    time_Trans = time.time() - time_Trans
    print "Temps mis pour la translation : %5.2g"%time_Trans

# Translation avec multi-threadings :
    print "Commence translation avec multi--threads : "
    NbThreads = 2
    Ni = NPOINTS/NbThreads
    t = NbThreads*[None]
    Tr_Points = N.empty((NPOINTS,3),N.double)
    time_Trans = time.time()
    for i in xrange(NbThreads) :
        t[i] = Thread(target= Geometry.translate, 
                      args = ( Points[i*Ni:(i+1)*Ni], tr, Tr_Points[i*Ni:(i+1)*Ni] ) )
        t[i].start()

    for i in xrange(len(t)) :
        t[i].join()
    time_Trans = time.time() - time_Trans
    print "Temps mis pour la translation multi-threads : %5.2g"%time_Trans

    print "Translated_Points[0] - Tr_Points[0] = ", Translated_Points[0]-Tr_Points[0]
    print "Translated_Points[-1] - Tr_Points[-1] = ", Translated_Points[-1]-Tr_Points[-1]
# On efface les tableaux qu'on vient de calculer :
    del Translated_Points
    del Tr_Points
########################################################################
# Rotation normale 
def testRotation() :
    print "Commence rotation sans multi--threads : "
    Rotated_Points = N.empty((NPOINTS,3),N.double)
    time_Rot = time.time()
    Rotated_Points = Geometry.rotate(Points, tr, 90.)
    time_Rot = time.time() - time_Rot
    print "Temps mis pour la translation : %5.2g"%time_Rot

# Translation avec multi-threadings :
    print "Commence rotation avec multi--threads : "
    NbThreads = 2
    Ni = NPOINTS/NbThreads
    t = NbThreads*[None]
    Rot_Points = N.empty((NPOINTS,3),N.double)
    time_Rot = time.time()
    for i in xrange(NbThreads) :
        t[i] = Thread(target= Geometry.rotate, 
                      args = ( Points[i*Ni:(i+1)*Ni], tr, 90., Rot_Points[i*Ni:(i+1)*Ni] ) )
        t[i].start()
        
    for i in xrange(len(t)) :
        t[i].join()
        time_Rot = time.time() - time_Rot
        print "Temps mis pour la rotation multi-threads : %5.2g"%time_Rot
        
        print "Rotated_Points[0]  - Rot_Points[0]  = ", Rotated_Points[0]  - Rot_Points[0]
        print "Rotated_Points[-1] - Rot_Points[-1] = ", Rotated_Points[-1] - Rot_Points[-1]

