# include <math.h>
# include "rotate.h"

void rotate( int nbNodes, const double* coords, const double* axis, double angle,
	     double* rot_coords )
{
  int c;
  double R[3][3];
  double cb, sb;

  cb = cos(angle);
  sb = sin(angle);
  /* Initialisation de la matrice de rotation : */
  R[0][0] = axis[0]*axis[0]*(1-cb)+cb;
  R[0][1] = axis[0]*axis[1]*(1.-cb)-axis[2]*sb;
  R[0][2] = axis[0]*axis[2]*(1.-cb)+axis[1]*sb;
  R[1][0] = axis[0]*axis[1]*(1.-cb)+axis[2]*sb;
  R[1][1] = axis[1]*axis[1]*(1.-cb)+cb;
  R[1][2] = axis[1]*axis[2]*(1.-cb)-axis[0]*sb;
  R[2][0] = axis[0]*axis[2]*(1.-cb)-axis[1]*sb;
  R[2][1] = axis[1]*axis[2]*(1.-cb)+axis[0]*sb;
  R[2][2] = axis[2]*axis[2]*(1.-cb)+cb;
  for ( c = 0; c < nbNodes; c++ )
  {
    int i,j;
    const double* vert = coords + 3*c;
    double* rvert = rot_coords + 3*c;
    rvert[0] = 0.; rvert[1] = 0.; rvert[2] = 0.;
    for ( i = 0; i < 3; i++ )
      for ( j = 0; j < 3; j++ )
	rvert[i] += R[j][i]*vert[j];
    }
}
