#!/usr/bin/env python
# -*- coding: latin-1 -*-

import CRationnel

class Rationnel :
    def __init__(self, p, q ) :
        '''
        Construit le rationnel p/q
        '''
        self.p, self.q = CRationnel.simplify(p,q)

    def __add__( self, r2 ) :
        '''
        Addition de deux rationnels
        '''
        return Rationnel(self.p*r2.q+self.q*r2.p,self.q*r2.q)

    def __sub__( self, r2 ) :
        '''
        Soustraction de deux rationnels
        '''
        return Rationnel(self.p*r2.q-self.q*r2.p,self.q*r2.q)

    def __mul__( self, r2 ) :
        '''
        Soustraction de deux rationnels
        '''
        return Rationnel(self.p*r2.p,self.q*r2.q)

    def __div__( self, r2 ) :
        '''
        Soustraction de deux rationnels
        '''
        if not r2.p == 0 :
            return Rationnel(self.p*r2.q,self.q*r2.p)
        else :
            return Rationnel(0,1)
    
    def __str__( self ) :
        if self.q != 1 :
            return "%d / %d"%(self.p,self.q)
        else :
            return "%d"%self.p

