
static int pgcd( const int& a, const int& b )
{
  int r;
  if ( ( b == 0 ) || ( a == 0 ) ) return 1;
  // On utilise l'algorithme d'Euclide pour calculer le pgcd de a et b :
  int p = ( a > 0 ? a : -a );
  int q = b;
  if ( p < q )
    {
      r = q;
      q = p;
      p = r;
    }
  
  r = p%q;
  while ( r != 0 )
  {
    p = q;
    q = r;
    r = p%q;
  }
  return q;
}

void simplify( int& p, int& q)
{
  // Simplifie le rationnel p/q afin que q et p soient premiers entre eux :
  int pgc = pgcd(p,q);
  p /= pgc;
  q /= pgc;
}
