/************************************************************************/
/**           Interface C pour utiliser les routines pythons...        **/
/************************************************************************/
# include <Python.h>
# include "rationnels.hpp"

// ========================================================================
// Definition de la fonction simplify pour python :
static char simplify_doc[] = "\
Pour p et q donné, retourne le couple (p/pgcd(p,q),q/pgcd(p,q)).";

static PyObject* py_simplify( PyObject* self, PyObject* args )
{
  int p,q;
  if ( !PyArg_ParseTuple( args, "ii", &p, &q) )
  {
    PyErr_SetString(PyExc_TypeError,
		    "La fonction attend deux entiers en entrée.");
	goto _fail;
  }
  simplify(p,q);
  return  Py_BuildValue("(ii)",p,q);
 _fail:
  return NULL;
}
// ========================================================================
// Dictionnaire de toutes les fonctions de ce module appelable en python
static PyMethodDef PyRationnels_Methods[] =
  {
    {"simplify", py_simplify, METH_VARARGS,  simplify_doc},
    {NULL, NULL}
  };
// ========================================================================
// Initialisation du module :
static char Rationnel_doc[] = "Utilitaires pour la gestion des rationnels.";

PyMODINIT_FUNC initCRationnel()
{
  PyObject* m;
  m = Py_InitModule4("CRationnel", PyRationnels_Methods, Rationnel_doc,
		     (PyObject*)NULL,PYTHON_API_VERSION);
}
