#!/usr/bin/python
# -*- coding: latin-1 -*-

class Vecteur :
    '''
    Dfini un vecteur de dimension n
    '''
    def __init__( self, dim ) :
        '''
        Construit un vecteur de dimension dim ne contenant que des 0
        '''
        self.coefs = [0]*dim

    def dim( self ) :
        return len(self.coefs)

    def __mul__( self, v ) :
        if self.dim() != v.dim() :
            raise ValueError, 'Dimensions incompatibles !'
        dot = 0.
        for i in range(self.dim()) :
            dot += self.coefs[i]*v.coefs[i]
        return dot

    def __getitem__( self, i ) :
        if ( i < 0 ) or ( i > self.dim() ) :
            raise IndexError, 'Valeurs indiciel invalide !'
        return self.coefs[i]

    def __setitem__( self, i, x ) :
        if ( i < 0 ) or ( i > self.dim() ) :
            raise IndexError, 'Valeurs indiciel invalide !'
        self.coefs[i] = x

    def __str__(self) :
        return str(self.coefs)

if __name__ == '__main__' :
    u = Vecteur(10)
    for i in range(u.dim()) :
        u[i] = i/2.
    v = Vecteur(5)
    for i in range(v.dim()) :
        v[i] = i*i
    try:
        dot_u = u*u
    except ValueError :
        print 'Bogue ? Normalement pas d exception ici...'

    try:
        dotuv = u*v
    except ValueError :
        print "L'exception tait bien attendue :)"
    
    try:
        u[2]  = 3
        u[-1] = 4
        u[0] = 5
    except IndexError :
        print "Exception attendue ;)"
    if u[0] == 5 :
        print "Par contre, u[0] n'aurait pas d tre modifi"
    print "u = ", u

