class domainClass:
    def __init__(self, nx, ny, dx, dy, x0=0., y0=0., nt=1, dt=0.1):
        self.nx = nx
        self.ny = ny
        self.nt = nt

        self.dx = dx
        self.dy = dy
        self.dt = dt

        self.x0 = x0
        self.y0 = y0
        
    def setDiscretizationPoint(self, problem):
        self.nxNoD = self.nx + 1
        self.nyNoD = self.ny + 1

        if problem.bc[0] == 'd':
            self.nxNoD -= 1
        if problem.bc[1] == 'd':
            self.nyNoD -= 1
        if problem.bc[2] == 'd':
            self.nxNoD -= 1
        if problem.bc[3] == 'd':
            self.nyNoD -= 1
        

class problemClass:
    def __init__(self, nu, vx, vy, c, bc, q=0):
        self.nu = nu
        self.vx = vx
        self.vy = vy
        self.c = c
        self.q = q
        self.bc = bc
