import mypackage as mp
import mpi4py.MPI as mpi
import numpy as np
import sys

#
# Calcul de dt(u) - laplacian(u) = 0
# par differences finies sur
# un carree avec des conditions de 
# Dirichlet 
# 0. en haut et en bas
# 99. a droite et a gauche
#

### second membre sur tout le domaine
def sol1(x, y):
    return np.zeros(x.shape)

### condition de Dirichlet a gauche et a droite
def f1(x):
    return 99.*np.ones(x.shape)

### condition de Dirichlet en haut et en bas
def f2(x):
    return np.zeros(x.shape)

### nombre de points sur chaque sous domaines
nx, ny = 20, 20
### taille du domaine global
Lx, Ly = 1., 1.

# Construction de la grande grille, determination des voisins du domaine courant 
# Npx: nombre de decoupage suivant x
# Npy: nombre de decoupage suivant y
if len(sys.argv) != 3:
    if mpi.COMM_WORLD.Get_rank() == 0:
        print """
    usage:
        mpiexec -np n python multiDomain.py npx npy
        ou
            npx: nombre de decoupage suivant x
            npy: nombre de decoupage suivant y
            n: npx*npy
    """
    sys.exit()
Npx, Npy = map(int, sys.argv[1:3])

dom, bc = mp.SetGrid(nx, ny, Lx, Ly, Npx, Npy)
p = mp.problemClass(1., 0., 0., 0., bc)
dom.setDiscretizationPoint(p)

u = mp.solveMultiDomain(dom, p, sol1, [f1, f2, f1, f2])

nx, ny = dom.nxNoD, dom.nyNoD
if mpi.COMM_WORLD.Get_rank() == 0:
    print u[nx-1:nx*ny+1:nx]
if mpi.COMM_WORLD.Get_rank() == 1:
    print u[0:nx*ny:nx]

#mp.plotSolution(u, dom)
mp.plotSolution_vtk(u, dom)
