import mypackage as mp
import numpy as np

#
# Calcul de -laplacian(u) = 0
# par differences finies sur
# un carree avec des conditions de 
# Dirichlet 
# 0. en haut et en bas
# 99. a droite et a gauche
#

### second membre Sur tout le domaine
def sol1(x, y):
    return np.zeros(x.shape)

### condition de Dirichlet a gauche et a droite
def f1(x):
    return 99.*np.ones(x.shape)

### condition de Dirichlet en haut et en bas
def f2(x):
    return np.zeros(x.shape)

### nombre de points 
nx, ny = 200, 200
### dimension du probleme
Lx, Ly = 1., 2.

### initialisation du domain et du probleme
dom, bc = mp.SetGrid(nx, ny, Lx, Ly, 1, 1)
p = mp.problemClass(1., 0., 0., 0., bc)
dom.setDiscretizationPoint(p)

u = mp.solveMonoDomain(dom, p, sol1, [f1, f2, f1, f2])

mp.plotSolution_vtk(u, dom)
