import mpi4py.MPI as mpi
from base import domainClass

def SetGrid(nx, ny, Lx, Ly, Npx, Npy):
    rank = mpi.COMM_WORLD.Get_rank()
    I = rank % Npx 
    J = rank / Npx

    bc = ['d','d','d','d']
    voisin = []
    bordInterface = []
    if I != 0:
        voisin.append(rank - 1)
        bordInterface.append(0)
        bc[0] = 'i'
    if I != Npx - 1:
        voisin.append(rank + 1)
        bordInterface.append(2)
        bc[2] = 'i'
    if J != 0:
        voisin.append(rank - Npx)
        bordInterface.append(1)
        bc[1] = 'i'
    if J != Npy - 1:
        voisin.append(rank + Npx)
        bordInterface.append(3)
        bc[3] = 'i'

    lx, ly = Lx/Npx, Ly/Npy
    dx, dy = lx/nx, ly/ny
    x0, y0 = I*lx, J*ly
    dom = domainClass(nx, ny, dx, dy, x0, y0)

    dom.lx, dom.ly = lx, ly
    dom.I, dom.J = I, J
    dom.voisin = voisin
    dom.bordInterface = bordInterface
    return dom, bc
        
