from assemble import laplacian, grad_dx, grad_dy, reac
import numpy as np
import scipy.sparse as sp

def buildA(domain, problem):
    """
    On construit la matrice A discretisant l'operateur diff
    et on extrait de A la matrice op_bord la matrice carre correspondant 
    aux points de l'interface. (op_bord a la meme taille que A) 
    """
    dx, nx = domain.dx, domain.nxNoD
    dy, ny = domain.dy, domain.nyNoD
    nu, c, vx, vy = problem.nu, problem.c, problem.vx, problem.vy
    bc = problem.bc
    return (nu*laplacian(dx, dy, nx, ny, bc) 
            + vx*grad_dx(dx, nx, ny, bc) 
            + vy*grad_dy(dy, nx, ny, bc) 
            + c*reac(nx, ny, bc))

def buildAt(domain, problem):
    """
    On construit la matrice A discretisant l'operateur diff
    et on extrait de A la matrice op_bord la matrice carre correspondant 
    aux points de l'interface. (op_bord a la meme taille que A) 
    """
    dx, nx = domain.dx, domain.nxNoD
    dy, ny = domain.dy, domain.nyNoD
    dt = domain.dt
    bc = problem.bc
    return 1./dt*reac(nx, ny, bc)

def buildb(domain, bc, f):
    """
    retourne les second membres initiaux dans les sous domaines
    """
    dx, nx, x0 = domain.dx, domain.nxNoD, domain.x0 
    dy, ny, y0 = domain.dy, domain.nyNoD, domain.y0 

    xbeg, xend = 0, domain.nx + 1
    ybeg, yend = 0, domain.ny + 1

    if bc[0] == 'd':
        xbeg += 1
    if bc[1] == 'd':
        ybeg += 1
    if bc[2] == 'd':
        xend -= 1
    if bc[3] == 'd':
        yend -= 1 
    
    x, y = np.meshgrid(xrange(xbeg, xend), xrange(ybeg, yend))
    x = x.reshape((nx*ny,))*dx + x0
    y = y.reshape((nx*ny,))*dy + y0
    return f(x, y)

def setDirichletCondition(b, domain, problem, dirichletFunction):
    dx, nx, x0 = domain.dx, domain.nxNoD, domain.x0 
    dy, ny, y0 = domain.dy, domain.nyNoD, domain.y0 

    xbeg, xend = 0, domain.nx + 1
    ybeg, yend = 0, domain.ny + 1

    dx2, dy2 = dx**2, dy**2
    bc = problem.bc

    if bc[0] == 'd':
        xbeg += 1
    if bc[1] == 'd':
        ybeg += 1
    if bc[2] == 'd':
        xend -= 1
    if bc[3] == 'd':
        yend -= 1 

    if bc[0] == 'd':
        y = np.array(xrange(ybeg, yend))
        b[0:nx*ny:nx] += dirichletFunction[0](y)*(problem.nu/dx2+problem.vx/(2.*dx))

    if bc[1] == 'd':
        x = np.array(xrange(xbeg, xend))
        b[0:nx] += dirichletFunction[1](x)*(problem.nu/dy2+problem.vy/(2.*dy))

    if bc[2] == 'd':
        y = np.array(xrange(ybeg, yend))
        b[nx-1:nx*ny+1:nx] += dirichletFunction[2](y)*(problem.nu/dx2-problem.vx/(2.*dx))

    if bc[3] == 'd':
        x = np.array(xrange(xbeg, xend))
        b[nx*(ny-1):nx*ny+1] += dirichletFunction[3](x)*(problem.nu/dy2-problem.vy/(2.*dy))

def initsol(domain, bc, initFunction):
    dx, nx, x0 = domain.dx, domain.nxNoD, domain.x0 
    dy, ny, y0 = domain.dy, domain.nyNoD, domain.y0 

    xbeg, xend = 0, domain.nx + 1
    ybeg, yend = 0, domain.ny + 1

    if bc[0] == 'd':
        xbeg += 1
    if bc[1] == 'd':
        ybeg += 1
    if bc[2] == 'd':
        xend -= 1
    if bc[3] == 'd':
        yend -= 1 

    x, y = np.meshgrid(xrange(xbeg, xend), xrange(ybeg, yend))
    x = x.reshape((nx*ny,))*dx + x0
    y = y.reshape((nx*ny,))*dy + y0
    return initFunction(x, y)
        
